/*
 * Decompiled with CFR 0.152.
 */
package com.example.demo1;

import java.awt.Desktop;
import java.awt.GraphicsEnvironment;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javafx.application.Application;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.PasswordField;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;
import javafx.stage.Stage;

public class HelloApplication
extends Application {
    public static void main(String[] args) {
        HelloApplication.launch(args);
    }

    @Override
    public void start(Stage primaryStage) {
        primaryStage.setTitle("DocDuck Maintenance Tool");
        try {
            Image icon = new Image(this.getClass().getResourceAsStream("/images/docduckicon.png"));
            primaryStage.getIcons().add(icon);
        }
        catch (NullPointerException e) {
            System.err.println("Error loading icon: " + e.getMessage());
        }
        BorderPane root = new BorderPane();
        root.getStyleClass().add("background-panel");
        root.getStyleClass().add("root");
        Font.loadFont(this.getClass().getResourceAsStream("/fonts/Inter.ttf"), 10.0);
        final VBox loginForm = this.createLoginForm();
        root.setCenter(loginForm);
        Scene scene = new Scene(root, 600.0, 600.0);
        String cssFile = this.getClass().getResource("/style.css").toExternalForm();
        if (cssFile != null) {
            scene.getStylesheets().add(cssFile);
        } else {
            System.err.println("CSS file not found!");
        }
        primaryStage.setScene(scene);
        primaryStage.setMinWidth(600.0);
        primaryStage.setMinHeight(600.0);
        primaryStage.setMaxWidth(GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds().width);
        primaryStage.setMaxHeight(GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds().height);
        scene.widthProperty().addListener(new ChangeListener<Number>(){

            @Override
            public void changed(ObservableValue<? extends Number> observableValue, Number oldSceneWidth, Number newSceneWidth) {
                loginForm.setPrefWidth(newSceneWidth.doubleValue());
            }
        });
        scene.heightProperty().addListener(new ChangeListener<Number>(){

            @Override
            public void changed(ObservableValue<? extends Number> observableValue, Number oldSceneHeight, Number newSceneHeight) {
                loginForm.setPrefHeight(newSceneHeight.doubleValue());
            }
        });
        primaryStage.show();
    }

    private VBox createLoginForm() {
        final VBox vbox = new VBox(10.0);
        vbox.setAlignment(Pos.CENTER);
        TextField usernameField = new TextField();
        usernameField.setPromptText("Username");
        usernameField.getStyleClass().add("text-field");
        PasswordField passwordField = new PasswordField();
        passwordField.setPromptText("Password");
        passwordField.getStyleClass().add("password-field");
        Hyperlink forgotPasswordLink = new Hyperlink("Forgot Password?");
        forgotPasswordLink.getStyleClass().add("forgot-password-link");
        forgotPasswordLink.setOnAction(new EventHandler<ActionEvent>(){

            @Override
            public void handle(ActionEvent event) {
                HelloApplication.this.openLink("https://docduck.000webhostapp.com");
            }
        });
        try {
            Image image = new Image(this.getClass().getResourceAsStream("/images/dockducklogo.png"));
            ImageView imageView = new ImageView(image);
            imageView.setFitWidth(529.0);
            imageView.setFitHeight(277.0);
            vbox.getChildren().add(imageView);
        }
        catch (NullPointerException e) {
            System.err.println("Error loading image: " + e.getMessage());
        }
        vbox.getChildren().addAll((Node[])new Node[]{usernameField, passwordField, forgotPasswordLink});
        Button signUpButton = new Button("Sign Up for Business");
        signUpButton.getStyleClass().add("sign-up-button");
        vbox.getChildren().addAll((Node[])new Node[]{new Region(), signUpButton});
        passwordField.setOnKeyPressed((EventHandler<? super KeyEvent>)new EventHandler<KeyEvent>(){

            @Override
            public void handle(KeyEvent event) {
                if (event.getCode() == KeyCode.ENTER) {
                    vbox.getChildren().clear();
                }
            }
        });
        return vbox;
    }

    private void openLink(String link) {
        try {
            Desktop.getDesktop().browse(new URI(link));
        }
        catch (IOException | URISyntaxException e) {
            e.printStackTrace();
        }
    }
}

